<?php
// Demand.php

class Demand
{
    private $car;

    public function __construct($car)
    {
        // $car is expected to be a mysqli connection object
        $this->car = $car;
    }

    public function licensevalidate()
    {
        // This function is assumed to perform some domain/license check.
        // Returning 1 for valid, 0 or some other value for invalid.
        // We assume 1 for valid operation in this example.
        return 1;
    }

    /**
     * Handles the administrator login process.
     * @param string $username The username/email.
     * @param string $password The password (expected to be plain text or a hash, depending on DB storage).
     * @param string $role The user role to check (e.g., 'admin').
     * @return int Returns 1 on successful login, 0 on failure (bad credentials), or -1 if license validation fails.
     */
    public function carlogin($username, $password, $role)
    {
        // Check License/Domain first
        if ($this->licensevalidate() != 1) {
            return -1; // License/Domain validation failure
        }

        // Use prepared statements to prevent SQL injection
        // Assuming your admin table is named 'admin' and stores plain passwords (though hashing is highly recommended)
        $stmt = $this->car->prepare("SELECT id FROM admin WHERE username = ? AND password = ?");

        if ($stmt === false) {
             // Handle DB error (e.g., logging connection issue)
             return 0; 
        }

        // Bind and execute
        // 'ss' means two string parameters
        $stmt->bind_param("ss", $username, $password);
        $stmt->execute();
        $stmt->store_result();

        // Check results
        if ($stmt->num_rows == 1) {
            return 1; // Success
        } else {
            return 0; // Failure (credentials did not match)
        }
    }

    public function carinsertdata($fields, $values, $table)
    {
        if ($this->licensevalidate() != 1) {
            return -1;
        }
        // ... (Logic for inserting data)
        $fields_str = implode(",", $fields);
        $placeholders = implode(",", array_fill(0, count($values), "?"));
        $stmt = $this->car->prepare("INSERT INTO $table ($fields_str) VALUES ($placeholders)");
        
        // Dynamically create types string and params array for bind_param
        $types = str_repeat("s", count($values));
        $bind_params = array_merge([$types], $values);
        
        $ref_params = [];
        foreach($bind_params as $key => $value) {
            $ref_params[$key] = &$bind_params[$key];
        }
        
        call_user_func_array([$stmt, 'bind_param'], $ref_params);
        
        return $stmt->execute() ? 1 : 0;
    }

    public function carinsertdata_Api_Id($fields, $values, $table)
    {
        if ($this->licensevalidate() != 1) {
            return -1;
        }
        // ... (Logic for inserting data and returning ID)
        $fields_str = implode(",", $fields);
        $placeholders = implode(",", array_fill(0, count($values), "?"));
        $stmt = $this->car->prepare("INSERT INTO $table ($fields_str) VALUES ($placeholders)");
        
        $types = str_repeat("s", count($values));
        $bind_params = array_merge([$types], $values);
        $ref_params = [];
        foreach($bind_params as $key => $value) {
            $ref_params[$key] = &$bind_params[$key];
        }
        call_user_func_array([$stmt, 'bind_param'], $ref_params);

        $stmt->execute();
        return $stmt->insert_id;
    }

    public function carinsertdata_Api($fields, $values, $table)
    {
        return $this->carinsertdata_Api_Id($fields, $values, $table);
    }
    
    public function carupdateData($field, $table, $where)
    {
        // Check License/Domain first
        if ($this->licensevalidate() != 1) {
            return -1; 
        }
        
        // Build the SET clause and parameter arrays
        $set_clause = [];
        $params = [];
        $types = '';

        foreach ($field as $key => $value) {
            $set_clause[] = "`" . $key . "` = ?";
            $params[] = $value;
            $types .= 's'; 
        }
        $set_string = implode(', ', $set_clause);

        // Construct the full SQL query 
        $sql = "UPDATE $table SET $set_string " . $where;
        
        $stmt = $this->car->prepare($sql);
        
        if ($stmt === false) {
             return 0; 
        }

        // Bind parameters (using call_user_func_array for dynamic parameters)
        $bind_params = array_merge([$types], $params);
        $ref_params = [];
        foreach($bind_params as $key => $value) {
            $ref_params[$key] = &$bind_params[$key];
        }
        call_user_func_array([$stmt, 'bind_param'], $ref_params);
        
        $result = $stmt->execute();
        
        if ($result) {
            return 1; 
        } else {
            return 0; 
        }
    }
}
// End of Demand.php